unit FileListBox;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.IO;

type
  TFileListBox = class(System.Windows.Forms.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ListBox1: System.Windows.Forms.ListBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ListBox1_DoubleClick(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}

  {$REGION 'Prywatne pola i metody'}
  strict private
  	//pola wewnetrzne
		listaKatalogow :array of String;
		listaPlikow :array of String;
		listaDyskow :array of String;
		pokazujDwieKropki :Boolean;
		//pola przechowujace ustawienia komponentu
		sciezkaKatalogu :String;
		uwzglednijKatalogi :Boolean;
		uwzglednijPliki :Boolean;
		uwzglednijDyski :Boolean;
		uwzglednijKatalogNadrzedny :Boolean;
		filtr :String;
    mozliweZmienianieKatalogow :Boolean;
    //metody
    procedure PobierzZawartoscKatalogu;
  {$ENDREGION}

  {$REGION 'Wlasnosci'}
  public
    procedure setDirectoryPath(ADirectoryPath :String);
    procedure setFilter(AFilter :String);
    procedure setDoubleDotVisible(ADoubleDotVisible :Boolean);
		procedure setDirectoriesVisible(ADirectoriesVisible :Boolean);
    procedure setFilesVisible(AFilesVisible :Boolean);
    procedure setDrivesVisible(ADrivesVisible :Boolean);
    function getFileName :String;

  published
    [Category('Directory'),Description('The DirectoryPath determines relative or absolute path of directory visible at component.')]
    property DirectoryPath :String read sciezkaKatalogu write setDirectoryPath;

		[Category('Directory'),Description('The Filter determines the mask of files in the list.')]
		property Filter :String read filtr write setFilter;

		[Category('Directory'),Description('The DoubleDotVisible determines if symbol of ***** directory should be displayed.')]
		property DoubleDotVisible :Boolean read uwzglednijKatalogNadrzedny write setDoubleDotVisible;

		[Category('Directory'),Description('The DirectoriesVisible determines if list of directories should be displayed.')]
		property DirectoriesVisible :Boolean read uwzglednijKatalogi write setDirectoriesVisible;

		[Category('Directory'),Description('The FilesVisible determines if list of files should be displayed.')]
    property FilesVisible :Boolean read uwzglednijPliki write setFilesVisible;

		[Category('Directory'),Description('The DrivesVisible determines if list of drives should be displayed.')]
		property DrivesVisible :Boolean read uwzglednijDyski write setDrivesVisible;

		[Category('Directory'),Description('The DirectoryChangeAllowed determines if user can change current directory by double-clicking on directory in the list.')]
    property DirectoryChangeAllowed :Boolean read mozliweZmienianieKatalogow write mozliweZmienianieKatalogow;

		[Category('Directory'),Description('The FileName expose the full path and filename to selected item.')]
		property FileName :String read getFileName;
  {$ENDREGION}

  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFileListBox))]

implementation

uses
  System.Globalization;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFileListBox.InitializeComponent;
begin
  Self.ListBox1 := System.Windows.Forms.ListBox.Create;
  Self.SuspendLayout;
  //
  // ListBox1
  //
  Self.ListBox1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListBox1.HorizontalScrollbar := True;
  Self.ListBox1.ItemHeight := 16;
  Self.ListBox1.Location := System.Drawing.Point.Create(0, 0);
  Self.ListBox1.Name := 'ListBox1';
  Self.ListBox1.Size := System.Drawing.Size.Create(376, 340);
  Self.ListBox1.TabIndex := 0;
  Include(Self.ListBox1.DoubleClick, Self.ListBox1_DoubleClick);
  //
  // TFileListBox
  //
  Self.Controls.Add(Self.ListBox1);
  Self.Name := 'TFileListBox';
  Self.Size := System.Drawing.Size.Create(376, 344);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

constructor TFileListBox.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;

  //inicjacja prywatnych pol klasy
	pokazujDwieKropki:=True;
	sciezkaKatalogu:=nil;
	uwzglednijKatalogi:=True;
	uwzglednijPliki:=True;
	uwzglednijDyski:=True;
	uwzglednijKatalogNadrzedny:=True;
	filtr:=nil;
  mozliweZmienianieKatalogow:=True;

  //zapelnianie listy
  PobierzZawartoscKatalogu;
end;

procedure TFileListBox.ListBox1_DoubleClick(sender: System.Object; e: System.EventArgs);
var
  przesuniecie,numer,poczatekPlikow,poczatekDyskow :Integer;
  nowaSciezkaKatalogu :String;
begin
  if not mozliweZmienianieKatalogow then Exit;

  //ustalanie pozycji grup elementow
  przesuniecie:=0;
  if pokazujDwieKropki and uwzglednijKatalogi then przesuniecie:=1;
	numer:=listBox1.SelectedIndex-przesuniecie; //+1 dla [..]
  poczatekPlikow:=0;
	if uwzglednijKatalogi then poczatekPlikow:=Length(listaKatalogow);
  poczatekDyskow:=poczatekPlikow;
  if uwzglednijPliki then poczatekDyskow:=poczatekDyskow+Length(listaPlikow);

	//zmiana katalogu
	nowaSciezkaKatalogu:=nil;
	if numer=-1 then nowaSciezkaKatalogu:=sciezkaKatalogu+'\..';
	if (numer>=0) and (numer<poczatekPlikow) then nowaSciezkaKatalogu:=listaKatalogow[numer];
	if numer>=poczatekDyskow then nowaSciezkaKatalogu:=listaDyskow[numer-poczatekDyskow];
	if (nowaSciezkaKatalogu<>nil) and (Directory.Exists(nowaSciezkaKatalogu)) then
		begin
		sciezkaKatalogu:=Path.GetFullPath(nowaSciezkaKatalogu);
		PobierzZawartoscKatalogu;
		end;
end;

procedure TFileListBox.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

procedure TFileListBox.PobierzZawartoscKatalogu;
type TablicaObiektow = array of TObject;
var i :Integer;
begin
if sciezkaKatalogu=nil then sciezkaKatalogu:=Directory.GetCurrentDirectory;

pokazujDwieKropki:=(sciezkaKatalogu<>Path.GetPathRoot(sciezkaKatalogu))
                   and uwzglednijKatalogNadrzedny;

if (not Directory.Exists(sciezkaKatalogu)) then
		raise Exception.Create('Katalog '+sciezkaKatalogu+' nie istnieje!');

ListBox1.Items.Clear;

if uwzglednijKatalogi then
		begin
		if pokazujDwieKropki then ListBox1.Items.Add('[..]');
		listaKatalogow:=Directory.GetDirectories(sciezkaKatalogu);
  	for i:=0 to Length(listaKatalogow)-1 do
    	listBox1.Items.Add('['+Path.GetFileName(listaKatalogow[i])+']');
		end;
if uwzglednijPliki then
		begin
    if (filtr<>nil) then
      listaPlikow:=Directory.GetFiles(sciezkaKatalogu,filtr)
      else
      listaPlikow:=Directory.GetFiles(sciezkaKatalogu);
    for i:=0 to Length(listaPlikow)-1 do
    	listBox1.Items.Add(Path.GetFileName(listaPlikow[i]));
		end;
if uwzglednijDyski then
		begin
		listaDyskow:=Directory.GetLogicalDrives();
		for i:=0 to Length(listaDyskow)-1 do
	    listBox1.Items.Add('<'+listaDyskow[i].Substring(0,2)+'>');
		end;
end;

procedure TFileListBox.setDirectoryPath(ADirectoryPath :String);
begin
sciezkaKatalogu:=ADirectoryPath;
PobierzZawartoscKatalogu;
end;

procedure TFileListBox.setFilter(AFilter :String);
begin
filtr:=AFilter;
PobierzZawartoscKatalogu;
end;

procedure TFileListBox.setDoubleDotVisible(ADoubleDotVisible :Boolean);
begin
uwzglednijKatalogNadrzedny:=ADoubleDotVisible;
PobierzZawartoscKatalogu;
end;

procedure TFileListBox.setDirectoriesVisible(ADirectoriesVisible :Boolean);
begin
uwzglednijKatalogi:=ADirectoriesVisible;
PobierzZawartoscKatalogu;
end;

procedure TFileListBox.setFilesVisible(AFilesVisible :Boolean);
begin
uwzglednijPliki:=AFilesVisible;
PobierzZawartoscKatalogu;
end;

procedure TFileListBox.setDrivesVisible(ADrivesVisible :Boolean);
begin
uwzglednijDyski:=ADrivesVisible;
PobierzZawartoscKatalogu;
end;

function TFileListBox.getFileName :String;
var
  przesuniecie,numer,poczatekPlikow,poczatekDyskow :Integer;
  pelnaSciezka :String;
begin
  if listBox1.SelectedIndex<0 then
    begin
    Result:=nil;
    Exit;
    end;

  przesuniecie:=0;
  if pokazujDwieKropki and uwzglednijKatalogi then przesuniecie:=1;
	numer:=listBox1.SelectedIndex-przesuniecie; //+1 dla [..]
  poczatekPlikow:=0;
	if uwzglednijKatalogi then poczatekPlikow:=Length(listaKatalogow);
  poczatekDyskow:=poczatekPlikow;
  if uwzglednijPliki then poczatekDyskow:=poczatekDyskow+Length(listaPlikow);

	pelnaSciezka:=nil; //ta wartosc zostanie gdy brak zaznaczonego elementu
	if (numer=-1) and (przesuniecie=1) then pelnaSciezka:=sciezkaKatalogu+'\..';
	if (numer>=0) and (numer<poczatekPlikow) then pelnaSciezka:=listaKatalogow[numer];
  if (numer>=poczatekPlikow) and (numer<poczatekDyskow) then pelnaSciezka:=listaPlikow[numer-poczatekPlikow];
  if numer>=poczatekDyskow then pelnaSciezka:=listaDyskow[numer-poczatekDyskow];

	if (pelnaSciezka=nil) then pelnaSciezka:='';

  Result:=Path.GetFullPath(pelnaSciezka);
end;

end.
